import SwiftUI

struct TimerWidget: Widget {
    class Configuration: ObservableObject {
        @Published var date: Date = .init()
    }

    private struct Content: View {
        @ObservedObject var configuration: Configuration

        var body: some View {
            Text(configuration.date, style: .relative)
        }
    }

    func make(configuration: Configuration) -> some View {
        Content(configuration: configuration)
    }
}
